#include "BarrierList.h"

BarrierList::BarrierList()
{
	barriers = 10000;
	size = 0;
	allocated = barriers * 4;

	barrierList = (double*)malloc(sizeof(double) * allocated);
	barrierIndices = (unsigned int*)malloc(sizeof(unsigned int) * allocated);

	for (int x = 0; x < barriers; x++)
	{
		barrierIndices[x] = x;
	}
}

BarrierList::~BarrierList()
{
	free(barrierList);
	free(barrierIndices);
}

void BarrierList::add(double* left, double* right)
{
	if (size < (barriers - 1))
	{
		barrierList[4 * size] = left[0];
		barrierList[4 * size + 1] = left[1];
		barrierList[4 * size + 2] = right[0];
		barrierList[4 * size + 3] = right[1];
		size++;
	}
}

void BarrierList::Render()
{
	if (size > 0)
	{
		int x = 0;
	}

	glVertexPointer(2, GL_DOUBLE, 0, barrierList);
	glDrawElements(GL_LINES, size * 2, GL_UNSIGNED_INT, barrierIndices);
}

void BarrierList::Clear()
{
	size = 0;
}