#include "Dragon.h"

// constructor
Dragon::Dragon()
{
	splits = 0;
}

// constructor
Dragon::Dragon( float left0,
			    float left1,
			    float right0,
				float right1)
{
	splits = 0;
	triangleList.add(left0, left1, right0, right1);
}

// destructor
Dragon::~Dragon()
{
}

bool Dragon::Split(HWND hDlg, int nIDDlgItem)
{
	if (triangleList.Split())
	{
		splits++;
		SetWindowText( GetDlgItem( hDlg, nIDDlgItem ), "Building Interior" );
		triangleList.BuildInterior(&insideList);
		SetWindowText( GetDlgItem( hDlg, nIDDlgItem ), "Building Barriers" );
		triangleList.BuildBarriers(&insideList, &barrierList);
		return true;
	}
	return false;
}

bool Dragon::FastSplit()
{
	if (triangleList.Split())
	{
		splits++;
		return true;
	}
	return false;
}

// OGL draw commands
void Dragon::DrawApprox( float* dragonColor )
{
	glColor4fv(dragonColor);
	triangleList.Render();
}


// OGL draw commands
void Dragon::DrawInside( float* dragonColor, float* boundaryColor )
{
	glColor4fv(dragonColor);
	insideList.Render();

	glColor4fv(boundaryColor);
	barrierList.Render();
}

// return total number of splits so far
int Dragon::GetSplits()
{
	return splits;
}

// return total number of triangles being drawn
int Dragon::GetApproxTotal()
{
	return triangleList.GetSize();
}

void Dragon::Dump(ostream& os)
{
	triangleList.Dump(os);
}

void Dragon::Load(istream& is)
{
	triangleList.Reset();
	insideList.Reset();
	barrierList.Clear();

	// load total splits
	is.read((char*)&(this->splits), sizeof(int));

	// load triangles
	double left0, left1, right0, right1;
	is.read((char*)&left0, sizeof(double));

	while (left0 != -100)
	{
		is.read((char*)&left1, sizeof(double));
		is.read((char*)&right0, sizeof(double));
		is.read((char*)&right1, sizeof(double));
		triangleList.add(left0, left1, right0, right1);

		if (is.eof())
		{
			left0 = -100;
		}
		else
		{
			is.read((char*)&left0, sizeof(double));
		}
	}

	// build other lists
	triangleList.BuildInterior(&insideList);
	triangleList.BuildBarriers(&insideList, &barrierList);
}

// calculate subset of all triangles that are visible
void Dragon::CompactVisibleApprox(float top, float bottom, float left, float right)
{
	triangleList.CompactVisible(top, bottom, left, right);
}

// calculate subset of all triangles that are visible
void Dragon::CompactVisibleInside(float top, float bottom, float left, float right)
{
	insideList.CompactVisible(top, bottom, left, right);
}

