#ifndef DRAGON_H
#define DRAGON_H

#include <windows.h>
#include <gl/gl.h>
#include <fstream.h>
#include "TriangleList.h"
#include "VisibleHash.h"
#include "BarrierList.h"

#define EPSILON 0.01
#define TWO_PI 6.28318

class Dragon
{

public:

	// constructor / destructors
	Dragon();
	Dragon( float left0,
			float left1,
			float right0,
			float right1);

	~Dragon();

	// visibility functions
	void CompactVisibleApprox(float top, float bottom, float left, float right);
	void CompactVisibleInside(float top, float bottom, float left, float right);

	// splitting functions
	bool Split(HWND hDlg, int nIDDlgItem);
	bool FastSplit();
	int GetSplits();
	int GetApproxTotal();

	// drawing functions
	void DrawApprox( float* dragonColor );
	void DrawInside( float* dragonColor, float* boundaryColor );

	// file functions
	void Load(istream& is);
	void Dump(ostream& os);

	// output total and visible traingles
	friend ostream& operator << (ostream& os, Dragon& triangleList);

private:
	TriangleList triangleList;
	TriangleList insideList;
	BarrierList barrierList;

	// total number of splits
	int splits;

	// hash table of visible vertices
	VisibleHash vertexHash;

	// hash table of triangle centers
	VisibleHash centerHash;
};

#endif