#ifndef TRIANGLELIST_H
#define TRIANGLELIST_H

#include <stdio.h>
#include <math.h>
#include <iostream.h>
#include <windows.h>
#include <gl/gl.h>
#include <fstream.h>
#include "VisibleHash.h"
#include "BarrierList.h"

#define EPSILON 0.01

/*
	triangle ordering:
		0	left0
		1	left1
		2	right0
		3	right1
		4	top0
		5	top1

*/

class TriangleList
{
public:
	TriangleList();
	TriangleList(double left0, double left1, 
				 double right0, double right1);
	~TriangleList();
	bool Split();
	void Reset();
	void Dump(ostream& os);
	int GetSize();
	void Render();

	void add(double left0, double left1, double right0, double right1);
	void add(double* triangle, double* hull);
	void CompactVisible(double top, double bottom, double left, double right);
	void BuildInterior(TriangleList* interior);
	void BuildBarriers(TriangleList* interior, BarrierList* bList);

private:
	double* triangleList;
	double* hullList;
	double* frustum;
	unsigned int* triangleIndices;
	
	int triangles;		// total triangles possible
	int size;			// total triangles used
	int allocated;		// total doubles allocated

	VisibleHash vertexHash;
	VisibleHash centerHash;

	bool IsInside( double* insideTest,
		 		   double* polygonPoints,
				   int totalPoints );

	bool IsVisible( double* convexHull, double top,
		  		    double bottom, double left, double right);

	bool Intersection(double* polygonPoints1, int totalPoints1,
		  			  double* polygonPoints2, int totalPoints2 );

	void CalcTop(double* toCalc);

	void CalcHull(double* triangle, double* convexHull);

	void NextLevel(double* triangleSplit, double* triangleStore, 
				   double* hullSplit, double* hullStore);

	void StompTriangle(double* stompee, double* stomper);

	void StompHull(double* stompee, double* stomper);

	void Init();

	bool IsInterior(double* currentTriangle);

	void CalcBarrier(double* currentTriangle, BarrierList* bList);
};

#endif