#include "VisibleHash.h"

// constructor
VisibleHash::VisibleHash()
{
	vertices.clear();
}


// destructor
VisibleHash::~VisibleHash()
{
	vertices.clear();
}


// insert item into hash table
//x is the parameter that generates the array index
//y is the value that is inserted

void VisibleHash::Insert( double x, double y )
{
	vertices.insert( std::multimap<double, double>::value_type( x * y, y ) );
}


// clear contents of hash table
void VisibleHash::Clear()
{
	vertices.clear();
}


// check to see if it is already a member
int VisibleHash::IsMember( double x, double y )
{
	// retrieve hits
	typedef std::multimap<double, double>::const_iterator ffIterate;
	std::pair<ffIterate, ffIterate> hits = vertices.equal_range( x * y );
	int totalHits = 0;

	// look for a match
	for(ffIterate I = hits.first; I != hits.second; ++I)
	{
		if ( I->second == y )
		{
			totalHits++;
		}
	}
	return totalHits;
}
