///////////////////////////////////////////////////////////////////////////////////
// File : CG_SOLVER.h
///////////////////////////////////////////////////////////////////////////////////
//
// Copyright 2006
// The University of North Carolina at Chapel Hill
// 
///////////////////////////////////////////////////////////////////////////////////
//
// Permission to use, copy, modify, distribute and sell this software and its 
// documentation for any purpose is hereby granted without fee, provided that 
// the above copyright notice appear in all copies and that both that copyright 
// notice and this permission notice appear in supporting documentation. 
// Binaries may be compiled with this software without any royalties or 
// restrictions. 
//
// The University of North Carolina at Chapel Hill makes no representations 
// about the suitability of this software for any purpose. It is provided 
// "as is" without express or implied warranty.
//

#ifndef CG_SOLVER_H
#define CG_SOLVER_H

#include "CELL.h"
#include <cmath>
#include <list>

using namespace std;

////////////////////////////////////////////////////////////////////
/// \brief Conjugate gradient Poisson solver.
////////////////////////////////////////////////////////////////////
class CG_SOLVER
{
public:
  //! constructor
	CG_SOLVER(int maxDepth, int iterations = 10, int digits = 8);
  //! destructor
	virtual ~CG_SOLVER();

  //! solve the Poisson problem
  virtual int solve(list<CELL*> cells);

  //! calculate the residual
  float calcResidual(list<CELL*> cells);

  //! accessor for the maximum number of iterations
  int& iterations() { return _iterations; };

protected:  
  int _iterations;  ///< maximum number of iterations
  int _digits;      ///< desired digits of precision

  ////////////////////////////////////////////////////////////////
  // conjugate gradient arrays
  ////////////////////////////////////////////////////////////////
  float* _direction;  ///< conjugate gradient 'd' array
  float* _potential;  ///< conjugate gradient solution, 'x' array
  float* _residual;   ///< conjugate gradient residual, 'r' array
  float* _q;          ///< conjugate gradient 'q' array
  
  int _arraySize;     ///< currently allocated array size
  int _listSize;      ///< current system size

  //! compute stencils once and store
  void calcStencils(list<CELL*> cells);

  //! reallocate the scratch arrays
  virtual void reallocate();

  //! physical lengths of various cell sizes
  float* _dx;
};

#endif
