///////////////////////////////////////////////////////////////////////////////////
// File : EXR.h
///////////////////////////////////////////////////////////////////////////////////
//
// Copyright 2006
// The University of North Carolina at Chapel Hill
// 
///////////////////////////////////////////////////////////////////////////////////
//
// Permission to use, copy, modify, distribute and sell this software and its 
// documentation for any purpose is hereby granted without fee, provided that 
// the above copyright notice appear in all copies and that both that copyright 
// notice and this permission notice appear in supporting documentation. 
// Binaries may be compiled with this software without any royalties or 
// restrictions. 
//
// The University of North Carolina at Chapel Hill makes no representations 
// about the suitability of this software for any purpose. It is provided 
// "as is" without express or implied warranty.
//

#ifndef EXR_H
#define EXR_H
#include <half.h>
#include <ImfRgbaFile.h>
#include <ImfStringAttribute.h>
#include <ImfMatrixAttribute.h>
#include <ImfArray.h>

////////////////////////////////////////////////////////////////////
/// \brief Wrapper for the ILM OpenEXR routines
////////////////////////////////////////////////////////////////////
class EXR  
{
public:
	EXR();
	virtual ~EXR();

  /// \brief write a float array out to an EXR file
  ///
  /// \param filename     name of output file
  /// \param image        float array to write to an EXR file
  /// \param width        width of float array
  /// \param height       height of float array
  static void writeEXR(const char* filename, float* image, int width, int height);
};

#endif
