///////////////////////////////////////////////////////////////////////////////////
// File : FFT.h
///////////////////////////////////////////////////////////////////////////////////
//
// Copyright 2006
// The University of North Carolina at Chapel Hill
// 
///////////////////////////////////////////////////////////////////////////////////
//
// Permission to use, copy, modify, distribute and sell this software and its 
// documentation for any purpose is hereby granted without fee, provided that 
// the above copyright notice appear in all copies and that both that copyright 
// notice and this permission notice appear in supporting documentation. 
// Binaries may be compiled with this software without any royalties or 
// restrictions. 
//
// The University of North Carolina at Chapel Hill makes no representations 
// about the suitability of this software for any purpose. It is provided 
// "as is" without express or implied warranty.
//

#ifndef FFT_H
#define FFT_H

#include <fftw3.h>
#include <iostream>

using namespace std;

////////////////////////////////////////////////////////////////////
/// \brief Wrapper class for FFTW
////////////////////////////////////////////////////////////////////
class FFT
{
public:
	FFT();
	virtual ~FFT();
  /// \brief convolve image and filter using FFTW
  ///
  /// \param source       source image
  /// \param kernel       convolution kernel
  /// \param xSource      width of source image
  /// \param ySource      height of source image
  /// \param xKernel      width of kernel
  /// \param yKernel      height yidth of kernel
  ///
  /// \return Returns the convolved image in the 'image' array. If the convolve fails, returns false
  static bool convolve(float* source, float* kernel, int xSource, int ySource, int xKernel, int yKernel);
};

#endif
